;;##########################################################################
;; systslot.lsp
;; Copyright (c) 1991-2002 by Forrest W. Young
;; Continuation of code for ViSta system object.  
;; slot accessor methods
;;##########################################################################


(defmeth vista-system-object-proto :plugin-ok-variable-types (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves the list of defined datasheet objects"
  (if set (setf (slot-value 'plugin-ok-variable-types) value))
  (slot-value 'plugin-ok-variable-types))

(defmeth vista-system-object-proto :plugin-model-prefix (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves the list of defined datasheet objects"
  (if set (setf (slot-value 'plugin-model-prefix) value))
  (slot-value 'plugin-model-prefix))

(defmeth vista-system-object-proto :datasheet-list (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves the list of defined datasheet objects"
  (if set (setf (slot-value 'datasheet-list) value))
  (slot-value 'datasheet-list))

(defmeth vista-system-object-proto :spreadplot-list (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves the list of defined spreadplot objects"
  (if set (setf (slot-value 'spreadplot-list) value))
  (slot-value 'spreadplot-list))

(defmeth vista-system-object-proto :fit-window-to-text? (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves whether help windows are sized to fit their text length"
  (if set (setf (slot-value 'fit-window-to-text?) value))
  (slot-value 'fit-window-to-text?))

(defmeth vista-system-object-proto :always-on-top (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves whether help windows are always on top"
  (if set (setf (slot-value 'always-on-top) value))
  (slot-value 'always-on-top))

(defmeth vista-system-object-proto :click-to-close (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves whether help windows can be clicked closed with left button"
  (if set (setf (slot-value 'click-to-close) value))
  (slot-value 'click-to-close))

(defmeth vista-system-object-proto :reuse-help-windows (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves whether help windows are reused"
  (if set (setf (slot-value 'reuse-help-windows) value))
  (slot-value 'reuse-help-windows))

(defmeth vista-system-object-proto :exit-style (&optional (value nil set))
"Message args: (&optional value)
 Sets or retrieves the exit style. Exit style may be one of the folowing strings
\"Flying\" \"Quick\" \"Safe\" "
  (if set (setf (slot-value 'exit-style ) value))
  (slot-value 'exit-style ))

(defmeth vista-system-object-proto :previous-plugins (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of all menu items appearing in the analysis menu."
  (if set (setf (slot-value 'previous-plugins) list))
  (slot-value 'previous-plugins))

(defmeth vista-system-object-proto :analysis-menu-item-titles (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of all menu items appearing in the analysis menu."
  (if set (setf (slot-value 'analysis-menu-item-titles) list))
  (slot-value 'analysis-menu-item-titles))

(defmeth vista-system-object-proto :data-object-list (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of all data-objects."
  (if set (setf (slot-value 'data-object-list) list))
  (slot-value 'data-object-list))

(defmeth vista-system-object-proto :expert (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the expert mode of the system."
  (if set (setf (slot-value 'expert) logical))
  (slot-value 'expert))

(defmeth vista-system-object-proto :guidemap (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the guidemap mode of the system."
  (if set (setf (slot-value 'guidemap) logical))
  (slot-value 'guidemap))

(defmeth vista-system-object-proto :show-help (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the show-help mode of the system."
  (if set (setf (slot-value 'show-help) logical))
  (slot-value 'show-help))

(defmeth vista-system-object-proto :show-first-help 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the show-first-help mode of the system."
  (if set (setf (slot-value 'show-first-help) logical))
  (slot-value 'show-first-help))

(defmeth vista-system-object-proto :show-menu-help-again
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the show-menu-help-again mode of the system."
  (if set (setf (slot-value 'show-menu-help-again) logical))
  (slot-value 'show-menu-help-again))

(defmeth vista-system-object-proto :pre-menu-help-menu-item-states
  (&optional (list-of-lists nil set))
"Message args: (&optional list-of-lists)
 Sets or retrieves the states of all menu items."
  (if set (setf (slot-value 'pre-menu-help-menu-item-states) list-of-lists))
  (slot-value 'pre-menu-help-menu-item-states))

(defmeth vista-system-object-proto :pre-menu-help-menu-states
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the states of all menu states."
  (if set (setf (slot-value 'pre-menu-help-menu-states) list))
  (slot-value 'pre-menu-help-menu-states))

(defmeth vista-system-object-proto :profiles 
  (&optional (list nil set))
  (if set (setf (slot-value 'profiles) list))
  (slot-value 'profiles))

(defmeth vista-system-object-proto :missing-values
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the missing-values mode of the system."
  (if set (setf (slot-value 'missing-values) logical))
  (slot-value 'missing-values))

(defmeth vista-system-object-proto :full-screen
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the full-screen mode of the system."
  (if set (setf (slot-value 'full-screen) logical))
  (slot-value 'full-screen))

(defmeth vista-system-object-proto :button-down 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether a guidemap button is down."
  (if set (setf (slot-value 'button-down) logical))
  (slot-value 'button-down))

(defmeth vista-system-object-proto :delay-update 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the updating of the guidemap window has been delayed."
  (if set (setf (slot-value 'delay-update) logical))
  (slot-value 'delay-update))

(defmeth vista-system-object-proto :long-menus
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the data and model menus show object names."
  (if set (setf (slot-value 'long-menus) logical))
  (slot-value 'long-menus))

(defmeth vista-system-object-proto :menu-states
  (&optional (string nil set))
"Message args: (&optional string)
 Sets or retrieves states of the menus. States can be a string that is Table, Matrix, MV, Enabled or Disabled."
  (if set (setf (slot-value 'menu-states) string))
  (slot-value 'menu-states))

(defmeth vista-system-object-proto :delay-return 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether returning to the parent guidemap window has been delayed."
  (if set (setf (slot-value 'delay-return) logical))
  (slot-value 'delay-return))

(defmeth vista-system-object-proto :instant-return 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether returning to the parent guidemap window is to instantly occur before map is displayed."
  (if set (setf (slot-value 'instant-return) logical))
  (slot-value 'instant-return))

(defmeth vista-system-object-proto :guidemap-name 
  (&optional (string nil set))
"Message args: (&optional string)
 Sets or retrieves the current guidemap name."
  (if set (setf (slot-value 'guidemap-name) string))
  (slot-value 'guidemap-name))

(defmeth vista-system-object-proto :guidemap-number 
  (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the current guidemap load sequence number."
  (if set (setf (slot-value 'guidemap-number) number))
  (slot-value 'guidemap-number))

(defmeth vista-system-object-proto :frames-per-second 
  (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of frames per second for this hardware."
  (if set (setf (slot-value 'frames-per-second) number))
  (slot-value 'frames-per-second))

(defmeth vista-system-object-proto :need-new-guidemap 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether a new guidemap needs to be loaded."
  (if set (setf (slot-value 'need-new-guidemap) logical))
  (slot-value 'need-new-guidemap))

(defmeth vista-system-object-proto :guidemap-slots 
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves list of guidemap slot values."
  (if set (setf (slot-value 'guidemap-slots) list))
  (slot-value 'guidemap-slots))

(defmeth vista-system-object-proto :show-guidemap
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the guidemap at startup."
  (if set (setf (slot-value 'show-guidemap) logical))
  (slot-value 'show-guidemap))

(defmeth vista-system-object-proto :hide-workmap
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to hide the workmap at startup."
  (if set (setf (slot-value 'hide-workmap) logical))
  (slot-value 'hide-workmap))

(defmeth vista-system-object-proto :show-toolbar
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the toolbar at startup."
  (if set (setf (slot-value 'show-toolbar) logical))
  (slot-value 'show-toolbar))

(defmeth vista-system-object-proto :show-welcome
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the welcome message at startup."
  (if set (setf (slot-value 'show-welcome) logical))
  (slot-value 'show-welcome))

(defmeth vista-system-object-proto :show-varobs
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the variable and observation windows at startup."
  (if set (setf (slot-value 'show-varobs) logical))
  (slot-value 'show-varobs))

(defmeth vista-system-object-proto :show-long-menus
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show long-menus at startup."
  (if set (setf (slot-value 'show-long-menus) logical))
  (slot-value 'show-long-menus))

(defmeth vista-system-object-proto :show-listener
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the listener at startup."
  (if set (setf (slot-value 'show-listener) logical))
  (slot-value 'show-listener))

(defmeth vista-system-object-proto :show-load-vista
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the load vista dialog at startup."
  (if set (setf (slot-value 'show-load-vista) logical))
  (slot-value 'show-load-vista))

(defmeth vista-system-object-proto :show-open-data
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the open-data-dialog at startup."
  (if set (setf (slot-value 'show-open-data) logical))
  (slot-value 'show-open-data))

(defmeth vista-system-object-proto :report-window-id-list
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of report-window object ids."
  (if set (setf (slot-value 'report-window-id-list) list))
  (slot-value 'report-window-id-list))

(defmeth vista-system-object-proto :directory-list
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of directories last used."
  (if set (setf (slot-value 'directory-list) list))
  (slot-value 'directory-list))

(defmeth vista-system-object-proto :vars-showing
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the showing status of the vars window."
  (if set (setf (slot-value 'vars-showing) logical))
  (slot-value 'vars-showing))

(defmeth vista-system-object-proto :obs-showing
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the showing status of the obs window."
  (if set (setf (slot-value 'obs-showing) logical))
  (slot-value 'obs-showing))

(defmeth vista-system-object-proto :help-showing
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the help window is showing."
  (if set (setf (slot-value 'help-showing) logical))
  (slot-value 'help-showing))

(defmeth vista-system-object-proto :background-color
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether background color is on."
  (if set (setf (slot-value 'background-color) logical))
  (slot-value 'background-color))

(defmeth vista-system-object-proto :color-values-list
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves color-values-list."
  (if set (setf (slot-value 'color-values-list) list))
  (slot-value 'color-values-list))

(defmeth vista-system-object-proto :applet-name
  (&optional (string nil set))
"Message args: (&optional string)
 Nil if not a guided applet, applet name otherwise."
  (if set (setf (slot-value 'applet-name) string))
  (slot-value 'applet-name))

(defmeth vista-system-object-proto :internal-map
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to read guidemap from file or internally."
  (if set (setf (slot-value 'internal-map) logical))
  (slot-value 'internal-map))

(defmeth vista-system-object-proto :applets
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether in applet mode."
  (if set (setf (slot-value 'applets) logical))
  (slot-value 'applets))

(defmeth vista-system-object-proto :redraw-active
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether a window is redrawing."
  (if set (setf (slot-value 'redraw-active) logical))
  (slot-value 'redraw-active))

(defmeth vista-system-object-proto :postponed-redraw-list
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of windows with postponed redraw requests."
  (if set (setf (slot-value 'postponed-redraw-list) list))
  (slot-value 'postponed-redraw-list))

(defmeth vista-system-object-proto :configure
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether in configuring mode."
  (if set (setf (slot-value 'configure) logical))
  (slot-value 'configure))

(defmeth vista-system-object-proto :vis-window-status
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the visualization windows status: t=open, nil=closed." 
  (if set (setf (slot-value 'vis-window-status ) logical))
  (slot-value 'vis-window-status ))

(defmeth vista-system-object-proto :help-window-status
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the help window status: t=open, nil=closed." 
  (if set (setf (slot-value 'help-window-status ) logical))
  (slot-value 'help-window-status ))

(defmeth vista-system-object-proto :var-window-object 
  (&optional (objid nil set))
"Message args: (&optional objid)
 Sets or retrieves the object identification of the variable window."
  (if set (setf (slot-value 'var-window-object) objid))
  (slot-value 'var-window-object))

(defmeth vista-system-object-proto :obs-window-object 
  (&optional (objid nil set))
"Message args: (&optional objid)
 Sets or retrieves the object identification of the observation window."
  (if set (setf (slot-value 'obs-window-object) objid))
  (slot-value 'obs-window-object))

(defmeth vista-system-object-proto :mat-window-object 
  (&optional (objid nil set))
"Message args: (&optional objid)
 Sets or retrieves the object identification of the matrix window."
  (if set (setf (slot-value 'mat-window-object) objid))
  (slot-value 'mat-window-object))

(defmeth vista-system-object-proto :cells-window-object 
  (&optional (objid nil set))
  (if set (setf (slot-value 'cells-window-object) objid))
  (slot-value 'cells-window-object))

(defmeth vista-system-object-proto :help-window-object 
  (&optional (objid nil set))
  (if set (setf (slot-value 'help-window-object) objid))
  (slot-value 'help-window-object))

(defmeth vista-system-object-proto :expert-window-size 
  (&optional (size-list nil set))
  (if set (setf (slot-value 'expert-window-size) size-list))
  (slot-value 'expert-window-size))

(defmeth vista-system-object-proto :expert-window-location 
  (&optional (location-list nil set))
  (if set (setf (slot-value 'expert-window-location) location-list))
  (slot-value 'expert-window-location))

(defmeth vista-system-object-proto :guide-window-size 
  (&optional (size-list nil set))
  (if set (setf (slot-value 'guide-window-size) size-list))
  (slot-value 'guide-window-size))

(defmeth vista-system-object-proto :guide-window-location 
  (&optional (location-list nil set))
  (if set (setf (slot-value 'guide-window-location) location-list))
  (slot-value 'guide-window-location))

(defmeth vista-system-object-proto :desktop-size 
  (&optional (number-list nil set))
  (if set (setf (slot-value 'desktop-size) number-list))
  (slot-value 'desktop-size))

(defmeth vista-system-object-proto :desktop-location 
  (&optional (number-list nil set))
  (if set (setf (slot-value 'desktop-location) number-list))
  (slot-value 'desktop-location))

(defmeth vista-system-object-proto :workmap-size 
  (&optional (number-list nil set))
  (if set (setf (slot-value 'workmap-size) number-list))
  (slot-value 'workmap-size))

(defmeth vista-system-object-proto :workmap-location 
  (&optional (number-list nil set))
  (if set (setf (slot-value 'workmap-location) number-list))
  (slot-value 'workmap-location))

(defmeth vista-system-object-proto :workmap-proportion 
  (&optional (number nil set))
  (if set (setf (slot-value 'workmap-proportion) number))
  (slot-value 'workmap-proportion))

(defmeth vista-system-object-proto :datasheet-location 
  (&optional (number-list nil set))
  (if set (setf (slot-value 'datasheet-location) number-list))
  (slot-value 'datasheet-location))

(defmeth vista-system-object-proto :datasheet-size 
  (&optional (number-list nil set))
  (if set (setf (slot-value 'datasheet-sizes) number-list))
  (slot-value 'datasheet-sizes))

(defmeth vista-system-object-proto :datasheet-sizes 
  (&optional (number-list nil set))
  (if set (setf (slot-value 'datasheet-sizes) number-list))
  (slot-value 'datasheet-sizes))

(defmeth vista-system-object-proto :spreadplot-sizes 
  (&optional (number-list nil set))
  (if set (setf (slot-value 'spreadplot-sizes) number-list))
  (slot-value 'spreadplot-sizes))

(defmeth vista-system-object-proto :spreadplot-size
  (&optional (number-list nil set))
  (if set (setf (slot-value 'spreadplot-sizes) number-list))
  (slot-value 'spreadplot-sizes))

(defmeth vista-system-object-proto :spreadplot-location
  (&optional (number-list nil set))
  (if set (setf (slot-value 'spreadplot-location) number-list))
  (slot-value 'spreadplot-location))

(defmeth vista-system-object-proto :normalsize 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to startup in normal mswindows window size."
  (if set (setf (slot-value 'normalsize) logical))
  (slot-value 'normalsize))

(defmeth vista-system-object-proto :save-desktop 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether desktop sizes being saved for next startup."
  (if set (setf (slot-value 'save-desktop) logical))
  (slot-value 'save-desktop))

(defmeth vista-system-object-proto :sob-names
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves stat obj names."
  (if set (setf (slot-value 'sob-names) list))
  (slot-value 'sob-names))

(defmeth vista-system-object-proto :font (&optional (string nil set))
  (if set (setf (slot-value 'font) string))
  (slot-value 'font))

(defmeth vista-system-object-proto :help-layout-sizeloc
  (&optional (number-list nil set))
"Message args: (&optional number-list)
 Sets or retrieves the help size and location layout."
  (if set (setf (slot-value 'help-layout-sizeloc) number-list))
  (slot-value 'help-layout-sizeloc))

(defmeth vista-system-object-proto :workmap-layout-sizeloc 
  (&optional (number-list nil set))
"Message args: (&optional number-list)
 Sets or retrieves the workmap size and location layout."
  (if set (setf (slot-value 'workmap-layout-sizeloc) number-list))
  (slot-value 'workmap-layout-sizeloc))

(defmeth vista-system-object-proto :screen-saver-time
  (&optional (minutes nil set))
"Message args: (&optional minutes)
 Sets or retrieves screen saver delay time, in minutes."
  (if set (setf (slot-value 'screen-saver-time) minutes))
  (slot-value 'screen-saver-time))

(defmeth vista-system-object-proto :screen-saver-on
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether screen saver is on."
  (when set (setf (slot-value 'screen-saver-on) logical))
  (slot-value 'screen-saver-on))

(defmeth vista-system-object-proto :screen-saver-clock
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether screen saver clock is shown."
  (when set (setf (slot-value 'screen-saver-clock) logical))
  (slot-value 'screen-saver-clock))

(defmeth vista-system-object-proto :screen-saver-full-screen
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether screen saver is full or half screen."
  (when set (setf (slot-value 'screen-saver-full-screen) logical) )
  (slot-value 'screen-saver-full-screen))

(defmeth vista-system-object-proto :show-flying-logo
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the show-flying-logo mode of the system."
  (if set (setf (slot-value 'show-flying-logo) logical))
  (slot-value 'show-flying-logo))

(defmeth vista-system-object-proto :list-vars ()
"Alias for list-variables"
  (send self :list-variables))

(defmeth vista-system-object-proto :list-var ()
"Alias for list-variables"
  (send self :list-variables))

(defmeth vista-system-object-proto :list-variables ()
"Args: none
Lists the variable names in the vars window."
  (when (not (equal *current-data* *current-object*))
        (setcd *current-data*))
  (send self :vars-showing t)
  (send (send self :var-window-object) :show-window))

(defmeth vista-system-object-proto :list-obs ()
"Alias for list-observations" 
  (send self :list-observations))

(defmeth vista-system-object-proto :list-observations () 
"Args: none
Lists the observations labels in the obs window."
  (when (not (equal *current-data* *current-object*))
        (setcd *current-data*))
  (send self :obs-showing t)
  (send (send self :obs-window-object) :show-window))

(defmeth vista-system-object-proto :list-mat ()
"Alias for list-matrices" 
  (send self :list-matrices))

(defmeth vista-system-object-proto :list-mats ()
"Alias for list-matrices" 
  (send self :list-matrices))

(defmeth vista-system-object-proto :list-matrices () 
"Args: None
Lists the matrix names in the mats window."
  (when (not (equal *current-data* *current-object*))
        (setcd *current-data*))
  (send self :obs-showing t)
  (send (send self :mat-window-object) :show-window))

(defmeth vista-system-object-proto :list-cells () 
  (when (not (equal *current-data* *current-object*))
        (setcd *current-data*))
  (send self :obs-showing t)
  (send (send self :cells-window-object) :show-window))

(defmeth vista-system-object-proto :plugin-data-types
  (&optional (list-of-lists nil set))
"Message args: (&optional list-of-lists)
 Sets or retrieves the list of lists of ok data-types."
  (if set (setf (slot-value 'plugin-data-types) list-of-lists))
  (slot-value 'plugin-data-types))

(defmeth vista-system-object-proto :plugin-menu-item-titles
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of lists of ok data-types."
  (if set (setf (slot-value 'plugin-menu-item-titles) list))
  (slot-value 'plugin-menu-item-titles))

(defmeth vista-system-object-proto :plugins
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of plugin names."
  (if set (setf (slot-value 'plugins) list))
  (slot-value 'plugins))

(defmeth vista-system-object-proto :plugin-dialog (&optional (logical nil set))
    (if set (setf (slot-value 'plugin-dialog) logical))
    (slot-value 'plugin-dialog))

(defmeth vista-system-object-proto :data-args
  (&optional (list-of-lists nil set))
"Message args: (&optional list-of-lists)
 Sets or retrieves the list of lists of data object arguments."
  (if set (setf (slot-value 'data-args) list-of-lists))
  (slot-value 'data-args))

(defmeth vista-system-object-proto :initial-spin (&optional (logical nil set))
    (if set (setf (slot-value 'initial-spin) logical))
    (slot-value 'initial-spin))